#include "MTApplication.h"
#include "MTExceptions.h"
#include <exception>

MTApplication	* gTheApp;

//	void main(void)
//	
//	main function, creates instance of app, runs and destructs
void main(void)
{
	gTheApp = new MTApplication;
	
	if(gTheApp)
	{
		try
		{
			gTheApp->Init();
			
			gTheApp->Run();
		}
		catch(MTException err)
		{
			err.DoFatalErrorDialog();
			
			ExitToShell();
		}
		catch(std::exception err)
		{
			char	buf[4096];
			
			std::sprintf(buf, "Unhandled STL Exception! (type = %s) This is a Bad Thing!", err.what());
			
			DoFatalError(buf);
		}
		catch(...)
		{
			DoFatalError("Unhandled Unknown Exception! This is a Bad Thing!");
			
			ExitToShell();
		}
		
		delete gTheApp;
	}
}